/*===================================
=            Global Vars            =
===================================*/
var $ = jQuery;
var pathname;
var full_url;
var swiper_home;
var autoplay_options = {
    delay: 3000,
    disableOnInteraction: false,
};

/*====================================================
=            Inits or Functions Excecutes            =
====================================================*/
$(document).ready(function () {


    /*----------  Pathname and Full Url  ----------*/
    pathname = window.location.pathname; // Returns path only
    full_url = window.location.href; // Returns full URL

    AOS.init({once:true});
    
    var slugsito = slug_js(full_url,'cancercenter/');
    
});


function validarEmail(valor) {
    if (/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(valor)) {
        return true;
    } else {
        return false;
    }
}

/**
 *
 * @function slug_js()
 * @description Obtiene el except del post con un numero de caracteres limitados.
 * @author Edgar Olivas Guzmán
 * @version 1.0
 * @type Post
 * @return string $data[1]
 * @date 25-09-2018
 *
 */
function slug_js(url, sitio) {
    var data = url.split(sitio);
    return data[1];
}



/**
 *
 * @function $('[redireccion]');
 * @description Ayuda a hacer una redirección manual a travez de un atributo
 * @author Edgar Olivas Guzmán
 * @version 1.0
 * @type URL
 * @date 25-09-2018
 */
$('[redireccion]').on('click', function () {
    location.href = $(this)[0].getAttribute('redireccion');
});




/**
 *
 * @function getFormData($form)
 * @description Función para obtener la data de formularios en especifico
 * @author Edgar Olivas Guzmán
 * @version 1.0
 * @type URL
 * @date 25-09-2018
 * @var $form // Nombre de el formulario a obtener la infomacion
 * @return indexed_array //Arreglo con la información de cada campo, este se rije con el atributto            name de cada input, select, checkbox, etc....
 */
function getFormData($form) {
    var unindexed_array = $form.serializeArray();
    var indexed_array = {};

    $.map(unindexed_array, function (n, i) {
        indexed_array[n['name']] = n['value'];
    });

    return indexed_array;
}

//Función que se encarga de generar un array en un object json para la modal de especialistas
function getFormDataArray($form) {
    var unindexed_array = $form.serializeArray();
    var indexed_object = { 'especialidades': [] };
    var indexed_subArray = [];
    var especialidad = '';
    var cedula = '';
    var numConsejo = '';
    $.map(unindexed_array, function (n, i) {
        if (i > 5) {
            var name = n['name'];
            name = name.substring(0, 1);
            switch (name) {
                case 'e':
                    especialidad = n['value'];
                    break;
                case 'c':
                    cedula = n['value'];
                    break;
                case 'n':
                    numConsejo = n['value'];
                    var object = { 'especialidad': especialidad, 'cedula': cedula, 'numConsejo': numConsejo };
                    indexed_subArray.push(object);
                    break;
            }
        } else {
            indexed_object[n['name']] = n['value'];
        }
    });

    indexed_object.especialidades.push(indexed_subArray);
    return indexed_object;
}


/**
 * @function validate($form)
 * @description Función para validar el formulario
 * @author Edgar Olivas Guzmán
 * @version 1.0
 * @type URL
 * @date 25-09-2018
 * @var $form // Nombre de el formulario a validar
 * @return true / false //Regresa el valor dependiendo si es un formulario o no.
 */
function validate($form) {
    if (!$form[0].checkValidity()) {
        $form.find('input[type="submit"]').click();
        return false;
    }
    return true;
}




/**
 * @function check_form(formulario)
 * @description Función para enviar el formulario median Ajax - Depende de send_mail para enviar la data recolectada
 * @author Edgar Olivas Guzmán
 * @version 1.0
 * @type URL
 * @date 25-09-2018
 * @var formulario // Nombre de el formulario a validar
 * @return data // Regresa en forma de JSON la informacion lista para hacer un envio a travez de AJAX o para cualquier otro tipo de uso.
 * */
function check_form(formulario) {
    var f = $(formulario);
    // console.log(f);
    if (validate(f)) {
        data = getFormData(f);
        // json_mails_cont = JSON.parse(mails); // '[1,"false",false]'
        // send_mail(data,f,json_mails_cont);
    }
}

function send_mail(datax, form, datamail) {
    //se genera el Ajax para la consulta de datos
    if (datax.nombre != '' && datax.correo != '') {
        if (validarEmail(datax.correo)) {
            $.ajax({
                beforeSend: function () {
                    // console.log('Se precarga contenido');
                },
                url: theme_url + '/SendMail/main_mail.php',
                type: 'post',
                data: {
                    datax: datax,
                    datam: datamail
                },
                success: function (resp) {
                    // console.log('Canalla Agency IT');
                },
                error: function (jqXHR, estado, error) {
                    // console.log(estado);
                    // console.log(error);
                },
                complete: function (jqXHR, estado) {
                    // console.log(estado);
                    form[0].reset();
                },
                timeout: 1800
            });
        }
    }
}

/* Se agrega eventos a las modales para el envio de correos*/
//peticion ajax para envio de correo para la modal agendar cita
$("#form-contacto").submit(function (e) {
    e.preventDefault();
    var f = $('#form-contacto');
    if (validate(f)) {
        if (validarEmail($('#correo_contacto').val())) {
            var numberTelefono = $('#telefono_contacto').val();
            numberTelefono = numberTelefono.replace(/\s+/g, '');
            if (numberTelefono.length <= 12 && numberTelefono != '' && numberTelefono.length >= 10) {
                data = getFormData(f);
                // console.log(data);
                // $("#btnAgendar").attr("disabled", "disabled");
                $.ajax({
                    url: './mailing/main_mail.php',
                    type: 'post',
                    data: {
                        datax: data,
                    },
                    success: function (resp) {
                        $("#form-contacto")[0].reset();
                        // $("#btnAgendar").removeAttr("disabled");

                        iziToast.show({
                            title: 'Enviado ✔',
                            message: 'Gracias por confiar en nosotros.',
                            backgroundColor: '#171c58',
                            messageColor: '#fff',
                            titleColor: '#fff'
                        });

                    },
                    error: function (jqXHR, estado, error) {
                        // $("#btnAgendar").removeAttr("disabled");
                        iziToast.show({
                            title: 'Error ×',
                            message: 'Fallo al enviar, Vuelve a intentarlo',
                            backgroundColor: 'red',
                            messageColor: '#fff',
                            titleColor: '#fff'
                        });
                    },
                    complete: function (jqXHR, estado) {

                    }

                });

            } else {
                iziToast.show({
                    title: 'Error ×',
                    message: 'El telefono no cumple con la logitud correcta (12 dígitos o menos)',
                    backgroundColor: 'red',
                    messageColor: '#fff',
                    titleColor: '#fff'
                });
            }
        } else {
            iziToast.show({
                title: 'Error ×',
                message: 'El correo no cumple el formato "example@example.example"',
                backgroundColor: 'red',
                messageColor: '#fff',
                titleColor: '#fff'
            });
        }
    } else {
        iziToast.show({
            title: 'Error ×',
            message: 'Completa los campos faltantes',
            backgroundColor: 'red',
            messageColor: '#fff',
            titleColor: '#fff'
        });
    }
});

$('.sub-item-menu.is-active').on('click',function(e){
    e.preventDefault();
});


var vh_window = $(window).height(); // returns height of browser viewport
var new_90 = vh_window / 80;
$(window).scroll(function () {
    var iCurScrollPos = $(this).scrollTop();
    if (iCurScrollPos > new_90) {
        $('.header').addClass('is-active');
    } else {
        $('.header').removeClass('is-active');
    }
});

// document.querySelectorAll('a[href^="#"]').forEach(anchor => {
//     anchor.addEventListener('click', function (e) {
//         e.preventDefault();

//         document.querySelector(this.getAttribute('href')).scrollIntoView({
//             behavior: 'smooth'
//         });
//     });
// });

$('.mobile_menu').on('click',function (e) { 
    e.preventDefault();
    element = $(this);
    $('.modal_menu_mobile').removeClass('is-open');
    setTimeout(function(){
        $('.modal_menu_mobile').removeClass('is-active');
    },300);
    setTimeout(function(){
        $('.burguer_menu').removeClass('is-active');
        location.href = element[0].getAttribute('href');
    },350);
});


$('.burguer_menu').on('click',function(){
    var burguer = $('.burguer_menu');
    if($('.burguer_menu').hasClass('is-active')){
        $('.modal_menu_mobile').removeClass('is-open');
        setTimeout(function(){
            $('.modal_menu_mobile').removeClass('is-active');
        },300);
        setTimeout(function(){
            burguer.removeClass('is-active');
        },350);
    }else{
        burguer.addClass('is-active');
        setTimeout(function(){
            $('.modal_menu_mobile').addClass('is-active');
        },50);
        setTimeout(function(){
            $('.modal_menu_mobile').addClass('is-open');
        },300);
    }
});